
-- Type: rs_produto
DO $$
BEGIN
	IF EXISTS (SELECT 1 FROM pg_type WHERE typname = 'rs_produto') THEN
		DROP TYPE rs_produto cascade;
	END IF;
END$$;

CREATE TYPE rs_produto AS
   (versao character varying(16),
    cd_emp integer,
    cd_filial integer,
    cd_prod integer,
    ds_prod character varying(100),
	nm_fabric character varying(100),
    vlr_tabela numeric(14,2),
    vlr_oferta numeric(14,2),
    qtde_ponto_fidel numeric(14,2),
    ctr_pmc integer,
    flag_verba_descon integer,
    flag_requer_receit integer,
    flag_alterar_preco integer,
    prod_uso_cont integer,
    tp_prod integer,
    vlr_custo numeric(14,2),
    cd_grp integer,
    qtd_ponto_venda double precision,
    lmt_prod_ponto_venda double precision,
    apres_qt_vd integer,
    qtde_estoque numeric(14,4),
    ds_tipo_receita character varying(100),
    ds_cor_receita character varying(100),
    perc_desc_limite numeric(14,4),
    cd_trib_fc character varying(3),
    perc_icms_n_cont_esta double precision,
    perc_red_vd double precision,
    libera_vd_conv integer,
    qtde_prod_max_conv integer,
    perc_desc_fix integer,
    tp_desconto integer,
    vlr_economia numeric(14,2),
    ds_desconto character varying(255),
    cd_tbl_desc integer,
    tp_nivel integer,
    perc_desc numeric(14,4),
    maior_perc_desc numeric(14,4),
    produto_controlado integer,
    flag_desconto_ticket_blq integer,
    perc_desc_fidel_max numeric(14,4),
    promo_industria integer,
    perc_desc_aniver numeric(14,4),
    perc_desc_clas numeric(14,4),
    vlr_desc_fabric numeric(14,2),
    campanha integer,
    qtde_prod_campanha integer,
    flag_bloqueia_desconto integer,
    perc_desc_pos_pbm double precision,
    cd_familia integer,
	ncm_prod character varying(50),
	nr_reg_ms character varying(150),
	qtde_limite_venda 	int,
	perc_pis		  	numeric(14,4),
	perc_cofins      	numeric(14,4), 
	ds_categoria 		character varying(200),
	ds_sub_categoria 	character varying(200),
	unidade_medida 		character varying(100),
	tp_tbl_desc 		int,
	dt_fim 				timestamp without time zone,
	qtde_limite_venda_familia integer

	 );
	 
	 
DROP TABLE IF EXISTS temp_rs_tipo_desc_cad;
DROP TABLE IF EXISTS temp_rs_tab_desc;
DROP TABLE IF EXISTS temp_rs_produto;
	
ALTER TYPE rs_produto
  OWNER TO postgres;
-- DROP FUNCTION public.p_est_prod_descontos(integer, integer, double precision, integer, character varying, integer, integer, double precision, integer, double precision, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.p_est_prod_descontos(
	integer,
	integer,
	double precision,
	integer,
	character varying,
	integer,
	integer,
	double precision,
	integer,
	double precision,
	integer,
	integer,
	integer,
	integer,
	integer)
    RETURNS SETOF rs_produto 
    LANGUAGE 'plpgsql'

    COST 10
    VOLATILE 
    ROWS 1000
AS $BODY$


	/*
	=======================================================================================
	'Nível Classificação.: INFORMAÇÃO RESTRITA
	'Versão..............: 20220810
	'Job.................:  
	'Nome................: P_EST_PROD_DESCONTOS
	'Objetivo............: RETORNAR DESCONTOS
	'Tabelas.............: FUNCAO PARA RETORNAR MELHOR DESCONTO OU DEFINIDO DAS TBLS DE DESCONTO NO POSTGRESQL
	'Dt Criação..........: 
	'Dt Ult Alteracão....: 2023-01-25
	'Alterado por........: Marcos barros - WANDERSON PIMENTA
	'Criado por..........: 
	'=======================================================================================
  
	FUNCAO PARA RETORNAR MELHOR DESCONTO OU DEFINIDO DAS TBLS DE DESCONTO NO POSTGRESQL
	  
	 in_cd_emp    --- CODIGO DA EMPRESA  
	 in_cd_filial   --- CODIGO DA FILIAL  
	 in_cd_prod   --- CODIGO DO PRODUTO  
	 in_cd_conv   --- CODIGO DO CONVENIO ( CASO SEJA CONVENIADO,SE NO FOR DEVE-SE PASSAR ZERO)  
	 in_nr_cartao_fidel --- NUMERO DO CARTAO FIDELIDADE ( CASO SEJA VENDA FIDELIDADE ,SE NO FOR DEVE-SE PASSAR ZERO)  
	 in_ean   --- FLAG PARA IDENTIFICAR O CÓDIGO EAN  
	 in_cd_cli  --- CODIGO DO CLIENTE PARA RETORNO DE DESCONTO CLIENTE  
	 in_qtde_prod --- QUANTIDADE DE PRODUTO PARA RETORNO DE DESCONTO POR QTDE DE PRODUTO  
	 in_application --- DEFINE QUAL APLICACAO SOLICITOU A CONSULTA DE PRODUTO  
	 in_id_promo	--- IDENTIFICAÇÃO DA PROMOÇÃO
	 in_is_receita  --- SE FOI VENDA COM RECEITA OU NÃO
	 in_cd_frm_pgto	--- FORMA DE PAGAMENTO SELECIONADA	
	 in_valida_sts_cred --- STATUS DE CREDT CONV E CREDIARIO


-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0 ,1) ---=15 parâm  
-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,'',0) ---=15 parâm  


	*/ 

	DECLARE
	---------------------------------------------------------
	----DECLARA AS VARIÁVEIS QUE ESTÃO NO CABEÇALHO DA FUNÇÃO
	---------------------------------------------------------

	in_cd_emp						ALIAS FOR $1;
	in_cd_filial					ALIAS FOR $2;
	in_cd_prod						ALIAS FOR $3;
	in_cd_conv						ALIAS FOR $4;
	in_nr_cartao_fidel				ALIAS FOR $5;
	in_ean							ALIAS FOR $6;
	in_cd_cli						ALIAS FOR $7;
	in_qtde_prod					ALIAS FOR $8;
	in_application					ALIAS FOR $9;
	in_id_promo						ALIAS FOR $10;
	in_is_receita					ALIAS FOR $11;
	in_cd_frm_pgto					ALIAS FOR $12;
	in_cd_vend						ALIAS FOr $13;
	in_cd_parceiro					ALIAS FOr $14;
	in_usa_desconto_propz_ident		ALIAS FOR $15;
	---------------------------------------------------------
	---FIM
	---------------------------------------------------------

	returnRec rs_produto; 	--RECEBERA OS DADOS DE RETORNO DA FUNCAO

	tmp_cd_barra                   character varying(13)  = '0';
	
	--declaracao variaveis   setando valores nas variaveis
	var_is_ctr_custo_semafaro      integer                = 0;
	var_is_agregar_desc_qtde       integer                = 0;
	var_is_orcamento_antigo		   integer                = 0;
	var_habilita_pontuacao_venda   integer                = 0;
	var_agregar_desc_qtde_em       character varying(255) = '';
	var_tp_prod                    integer                = -1;
	var_vlr_custo                  double precision       = 0;
	var_qtde_ponto_fidel           double precision       = 0;
	var_perc_desc_limite           double precision       = 0;
	var_qtde_estoque               numeric(14,4)          = 0;
	var_qtd_ponto_venda            double precision       = 0;
	var_lmt_prod_ponto_venda       double precision       = 0;
	var_campanha                   integer                = 0;
	var_qtde_prod_campanha         integer                = 0;
	var_valida_sts_cred_conv       integer                = 1;
	var_valida_sts_cred_crediario  integer                = 1;
	var_permite_desc_oferta		   integer                = 0;
	var_flag_vd_call_center		   integer                = 0;
	
	-- variaveis de manipulacao de desconto
	var_cd_tbl_desc                integer                = 0;
	var_tp_desc                    integer                = 0;
	var_flag_desc_fix              integer                = 0;
	var_perc_desc                  double precision       = 0;
	var_perc_desc_max              double precision       = 0;
	var_tp_nivel                   integer                = 0;
	var_exclue_oferta              integer                = 0;
	var_qt_max                     integer                = 0;
	var_libera_vd_conv             integer                = 0;
	var_is_cli_fidel               integer                = 0;
	var_mes_dt_nasc_cli            integer                = 0;
	var_ds_cor_receita             character varying(255) = '';
	var_ds_tipo_receita            character varying(255) = '';
	var_agregacao                  integer                = 0;
	var_qtde_pag                   integer                = 0;
	var_perc_desc_oferta           double precision       = 0;
	var_perc_desc_oferta_max       double precision       = 0;
	var_in_cd_prod                 integer                = 0;
	var_in_cd_conv                 integer                = 0;
	var_vlr_oferta                 double precision       = 0;
	var_vlr_tabela                 double precision       = 0;
	var_usa_cartao_para_fidelidade integer                = 0;
	var_perc_desc_pos_pbm          double precision       = 0;
	
	var_cli_crediario              integer                = 0;
	var_cd_mdl_vd_crediario        integer                = 0;
	var_cd_mdl_vd_convenio         integer                = 0;
	var_desconto_especial          integer                = 3;  -- 0-DESCONTO_DESTE_CADASTRO; 1-CONVENIO; 2-CREDIARIO; 3-MELHOR_DESCONTO 
	vr_pgto_avista                 integer                = 0;
	var_somente_desc_convenio      integer                = 0;
	var_integra_pontuacao          integer                = 0;
    var_temp_record                record;
	var_estoque_prevendido         integer                = 0;
	var_motivo_sts_prod            character varying(500) = '';
	var_cd_familia                 integer                = 0;
	var_dt_fim 					   timestamp without time zone;
	var_qtde_limite_venda          int					  = 0;
	var_tp_tbl_desc				   integer				  = 3 ;  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
	 
	var_usa_desc_exclusivo 	integer;
	var_tabelas_exclusivas 	integer;
	var_qtde_limite_venda_familia  integer				  = 0;
	
	--------------------------------------------------
	-- var tmp para teste
	tmp_teste record;
	
BEGIN
	--- criando tabelas temporarias
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		DROP TABLE temp_rs_tab_desc;
		EXCEPTION WHEN OTHERS THEN
	END;
	
	BEGIN
		CREATE TEMPORARY TABLE temp_rs_tab_desc
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			tp_tbl_desc			integer,     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
			dt_fim              timestamp without time zone
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_rs_tab_desc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	
	BEGIN
		CREATE TEMPORARY TABLE temp_rs_tipo_desc_cad
		(	
			cd_tp_desconto 		integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_rs_tipo_desc_cad; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	
	BEGIN
		DROP TABLE temp_rs_produto;
		EXCEPTION WHEN OTHERS THEN
	END;
	
	BEGIN
		CREATE TEMPORARY TABLE temp_rs_produto
		(   -- valores de consulta unica
			cd_emp integer,
			cd_filial integer,
			cd_prod integer,
			ds_prod character varying(100),
			nm_fabric character varying(100),
			vlr_tabela numeric(14,2),
			vlr_oferta numeric(14,2),
			qtde_ponto_fidel numeric(14,2),
			ctr_pmc integer,
			lib_desc_verba integer,
			flag_requer_receit integer,
			flag_alterar_preco integer,
			prod_uso_cont integer,
			tp_prod integer,
			vlr_custo numeric(14,2),
			cd_grp integer,
			qtd_ponto_venda double precision,
			lmt_prod_ponto_venda double precision,
			apres_qt_vd integer,
			qtde_estoque numeric(14,4),
			ds_tipo_receita character varying(100),
			ds_cor_receita character varying(100),
			perc_desc_limite numeric(14,4),	
			cd_trib_fc  character varying(3), 
			perc_icms_n_cont_esta double precision, 
			perc_red_vd double precision,					
			libera_vd_conv integer,
			qtde_prod_max_conv integer,			

			fixa_desconto integer,			
			tp_desconto integer,
			vlr_economia numeric(14,2),
			ds_desconto character varying(255),	
			cd_tbl_desc integer,
			tp_nivel integer,
			perc_desc numeric(14,4),
			perc_desc_max numeric(14,4),
			produto_controlado integer,
			-- AVALIAR COLUNAS ABAIXO
			flag_desconto_ticket_blq integer,      
			perc_desc_fidel_max numeric(14,4),        
			promo_industria  integer,         
			perc_desc_aniver numeric(14,4),      
			perc_desc_clas  numeric(14,4),     
			vlr_desc_fabric numeric(14,4),		      
			campanha integer,      
			qtde_prod_campanha integer,   
			flag_bloqueia_desconto integer,
    		perc_desc_pos_pbm 	double precision,
			cd_familia 			integer,
			ncm_prod 			character varying(50),
			nr_reg_ms 			character varying(150),
			qtde_limite_venda 	int,
			perc_pis		  	numeric(14,4),
			perc_cofins      	numeric(14,4), 
			ds_categoria 		character varying(200),
	        ds_sub_categoria 	character varying(200),
			unidade_medida 		character varying(100),
			tp_tbl_desc 		integer,    --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
			dt_fim 				timestamp without time zone,
			qtde_limite_venda_familia integer
			
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_rs_produto; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;

	-----------------PROCESSAMENTO DA PROCEDURE------------------------------------------------
	
 IF exists ( select * from est_forma_pgto where ds_frm_pgto LIKE 'CONV%' and regra_desconto in (1,3) and cd_frm_pgto = in_cd_frm_pgto and  sts_frm_pgto = 0  limit 1 ) then
           IF NOT EXISTS (SELECT *
       						FROM 
       						est_forma_pgto a INNER JOIN est_forma_pgto_moeda b ON  
       						a.cd_emp = b.cd_emp AND 
       						a.cd_frm_pgto = b.cd_frm_pgto 
       						WHERE 
       						a.cd_frm_pgto = in_cd_frm_pgto 						
       						AND a.regra_desconto in (1,3)
							and sts_frm_pgto = 0
       					) THEN		
       		in_cd_conv = 0;
       	END IF; 
   end if;
	

	
	
	IF in_ean = 1 THEN -- CONSULTANDO CODIGO DE BARRAS
		tmp_cd_barra = lpad(CAST(CAST(in_cd_prod AS bigint) AS character varying),13,'0');
	
		var_in_cd_prod = (SELECT 
							COALESCE(cd_prod, 0) 
		                FROM 
							est_prod_cd_barra 
					   WHERE 
							cd_emp = in_cd_emp AND 
					        cd_barra = tmp_cd_barra and flag_pre_vencidos = 1);

		IF not var_in_cd_prod ISNULL  and var_in_cd_prod > 0 THEN -- VERIFICA SE EXISTE PRODUTO PRE VENCIDO
			
			var_estoque_prevendido = COALESCE((SELECT b.qtde_prod
				from est_prod_rem_pre_venc_it_lote a inner join
					 est_prod_cpl_lote b on 
						a.cd_emp = b.cd_emp and 
						a.cd_filial = b.cd_filial and 
						a.cd_lote = b.cd_lote
				where b.cd_emp = in_cd_emp and b.cd_filial = in_cd_filial 
				and b.cd_prod = var_in_cd_prod and a.ean = tmp_cd_barra),0);
		
			IF var_estoque_prevendido < in_qtde_prod then				
				RAISE EXCEPTION 'Produto PRE-VENCIDO não tem estoque para venda - ESTOQUE ATUAL % UNIDADE(S).', var_estoque_prevendido;
			end if;
		
			
		END IF; -- fim in_cd_prod

							
		IF var_in_cd_prod = 0 OR var_in_cd_prod ISNULL  THEN -- VERIFICA SE EXISTE PRODUTO
			var_in_cd_prod = (SELECT 
							COALESCE(cd_prod, 0) 
		                FROM 
							est_prod_cd_barra 
					   WHERE 
							cd_emp = in_cd_emp AND 
					        cd_barra = tmp_cd_barra);
		END IF;
	
		IF var_in_cd_prod = 0 OR var_in_cd_prod ISNULL  THEN -- VERIFICA SE EXISTE PRODUTO
			IF in_cd_prod > 1000000000 THEN
				RAISE EXCEPTION 'Produto não encontrado para o codigo de barra %.', tmp_cd_barra;
			ELSE
				var_in_cd_prod = CAST(in_cd_prod as bigint);
			END IF;			
		END IF; -- fim in_cd_prod

	ELSE

		IF in_cd_prod > 1000000000 THEN
			RAISE EXCEPTION 'Produto não encontrado para o codigo %.', in_cd_prod;
		ELSE
			var_in_cd_prod = CAST(in_cd_prod as bigint);
		END IF;

		
	END IF; -- fim in_ean
	
	
		var_flag_vd_call_center = (select flag_vd_call_center 
                                     from est_prod 
                                    where cd_emp  = in_cd_emp 
                                      and cd_prod = var_in_cd_prod );
    if var_flag_vd_call_center = 1 then
         RAISE EXCEPTION 'Produto: %  com venda somente no TELEVENDAS.', in_cd_prod;
   end if ; 
           

	
	
	IF NOT EXISTS (SELECT 
						CD_EMP 
				   FROM 
						est_prod_cpl 
				   WHERE 
						cd_emp = in_cd_emp 
						AND cd_filial = in_cd_filial 
						AND cd_prod = var_in_cd_prod
					LIMIT 1) THEN
		RAISE EXCEPTION 'Produto % não encontrado para a filial %.', var_in_cd_prod, in_cd_filial;
	END IF;
	
	--CAPTURANDO FAMILIA DO PRODUTO
	var_cd_familia = COALESCE((SELECT arv.cd_arv_merc_familia
								FROM 	est_prod_est_arv_mercadologica arv 
								WHERE   arv.cd_emp = in_cd_emp AND arv.cd_prod = var_in_cd_prod), 0);
	
	--CAPTURANDO QTDE FAMILIA DO PRODUTO
	var_qtde_limite_venda_familia = COALESCE((SELECT fqtde.qtde_limite_venda
								FROM 	est_arv_merc_familia fqtde 
								WHERE   fqtde.cd_emp = in_cd_emp AND fqtde.cd_arv_merc_familia = var_cd_familia), 0);
								
	--CAPTURANDO PARAMETRO SEMAFARO
	var_is_ctr_custo_semafaro    = COALESCE((SELECT 
												COALESCE(CAST(valor AS integer), 0) 
											FROM 
												prc_emp_config 
											WHERE 
												cd_emp = in_cd_emp 
												AND cd_chave ILIKE 'CTR_CUSTO_SEMAFORO'), 0);
	
	--capturando tipo de integracao de pontuacao
	var_integra_pontuacao = COALESCE((SELECT 
										COALESCE(CAST(valor AS integer), 0) 
									  FROM 
										prc_filial_config 
									  WHERE 
										cd_emp = in_cd_emp AND 
										cd_filial = in_cd_filial AND 
										cd_chave ILIKE 'TP_INTEGRACAO_FIDEL') , 0);
										

	 
	
	--validando tipo produto
	SELECT COALESCE((CASE var_is_ctr_custo_semafaro WHEN 0 THEN 
                                    vlr_custo
                                ELSE 
                                    vlr_custo_md
                            END), 0), 
			COALESCE(tp_prod, -1),
			COALESCE(qtde_ponto_fidel, 0),
			COALESCE(CAST(qt_est AS integer), 0)
	INTO 
		STRICT var_vlr_custo, 
		var_tp_prod, 
		var_qtde_ponto_fidel, 
		var_qtde_estoque 
	FROM 
		est_prod_cpl 
	WHERE 
		cd_emp = in_cd_emp 
		AND cd_filial = in_cd_filial 
		AND cd_prod = var_in_cd_prod;
	
	IF NOT EXISTS (SELECT 
					1 
				WHERE 
					var_tp_prod IN ( 0, 9, 10, 11 )) THEN
		RAISE EXCEPTION 'Venda de produto como o tipo %s não é permitida.', var_tp_prod;  
	END IF;
	
	/* var_qtde_estoque = CASE WHEN var_qtde_estoque < 0 THEN 0 ELSE var_qtde_estoque END; */
	
	/* IF EXISTS (SELECT 
					1 
				WHERE var_tp_prod IN ( 9, 10, 11 )) THEN
		var_qtde_estoque = in_qtde_prod;
	END IF; */

	var_cli_crediario       = coalesce((select 
											1 
										from 
											rc_cli_crediario 
										where 
											cd_emp = in_cd_emp and 
											cd_cli  = in_cd_cli 
										limit 1),0);
	var_cd_mdl_vd_crediario = coalesce((select 
											cd_mdl_vd 
										from 
											rc_cli_crediario 
										where 
											cd_emp = in_cd_emp and 
											cd_cli  = in_cd_cli 
										limit 1),0);
	var_cd_mdl_vd_convenio  = coalesce((select 
											cd_mdl_vd 
										from 
											rc_cli_conv 
										where 
											cd_emp = in_cd_emp and 
											cd_conv  = in_cd_conv 
										limit 1),0);
	
	--Verificando se existe e somente para enviar descontos proveniente do cadastro do convenio
	var_somente_desc_convenio= coalesce((select 
											FLAG_SOMENTE_DESC_CONTRATO 
										from 
											rc_cli_conv 
										where 
											cd_emp = in_cd_emp and 
											cd_conv  = in_cd_conv
										limit 1),0);
										
/*	IF (in_cd_frm_pgto = (SELECT CD_FRM_PGTO FROM est_forma_pgto WHERE DS_FRM_PGTO LIKE 'CONV%' LIMIT 1)) THEN
		var_somente_desc_convenio = 1;
	END IF;
*/
	-- CAPTURA DE CAMPANHAS
	--HABILITA PONTUACAO NA VENDA
	-- CAPTURA DE CAMPANHAS PONTOS VENDA
	BEGIN
		SELECT
			COALESCE(a.qt_pontos_troca, 0)qt_pontos_troca,
         	COALESCE(a.qtde_limite_venda, 0)qtde_limite_venda
				, 2 as tp_tbl_desc
         INTO 
			STRICT var_qtd_ponto_venda, 
			var_lmt_prod_ponto_venda,
			var_tp_tbl_desc
		FROM 
			pdv_campanha_adicionais_pontuacao_est_prod_campanha a INNER JOIN pdv_campanha_adicionais_pontuacao_prc_filial b ON
			a.cd_emp = b.cd_emp AND
         	a.cd_campanha_adic = b.cd_campanha_adic
			inner join pdv_campanha_adicionais as c on
         	a.cd_emp = c.cd_emp and
         	a.cd_campanha_adic = c.cd_campanha_adic
        where 
			a.cd_emp = in_cd_emp and 
			b.cd_filial = in_cd_filial and 
			a.cd_prod = var_in_cd_prod and 
			cast (c.dt_inicio as date ) <= cast (current_date as date )and
			cast (c.dt_valid as date )>= cast (current_date as date )
			and (
					((in_usa_desconto_propz_ident = 1) AND (c.flag_tp_desconto_propz in(0,1))) OR 
					((in_usa_desconto_propz_ident = 0) AND (c.flag_tp_desconto_propz =0))
				)				
 		ORDER BY 
			a.dt_valid DESC 
		LIMIT 1;

		EXCEPTION
			WHEN NO_DATA_FOUND THEN
	END;
	
	-- CAPTURA DE CAMPANHAS QUANTIDADE DE PRODUTO
	BEGIN
		SELECT  
			COALESCE(a.cd_campanha_adic, 0)cd_campanha_adic,
			COALESCE(c.qtde_prod, 0)qtde_prod
			, 2 as tp_tbl_desc
		INTO 
			STRICT var_campanha, 
			var_qtde_prod_campanha 
			, var_tp_tbl_desc
		FROM 
			pdv_campanha_adicionais a INNER JOIN pdv_campanha_adicionais_prc_filial b ON		
			a.cd_emp = b.cd_emp AND
			a.cd_campanha_adic = b.cd_campanha_adic 
			INNER JOIN pdv_campanha_adicionais_est_prod_campanha c ON	
			a.cd_emp = c.cd_emp AND
			a.cd_campanha_adic = c.cd_campanha_adic
		WHERE 
			a.cd_emp = in_cd_emp AND 
			b.cd_filial = in_cd_filial AND 
			c.cd_prod = var_in_cd_prod 
			AND cast (a.dt_inicio as date )<= cast (CURRENT_DATE as date )
			AND cast (a.dt_valid as date )>= cast (CURRENT_DATE as date)
			and (
					((in_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR 
					((in_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
				)				
		ORDER BY 
			a.dt_valid DESC 
		LIMIT 1;

		EXCEPTION
		WHEN NO_DATA_FOUND THEN
	END;

 -- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
	  
	-- CAPTURA INFORMACOES DE TIPO DE RECEITA
	BEGIN
		SELECT  
			COALESCE(b.ds_cor, ''),
			COALESCE(c.ds_tp_receita, '')
		INTO 
			STRICT var_ds_cor_receita, 
			var_ds_tipo_receita
		FROM 
			est_prod a LEFT JOIN glb_cor_receita b ON
			a.cd_emp = b.cd_emp AND
			a.cd_cor_receita = b.cd_cor 
			LEFT JOIN glb_tp_receita c ON
			a.cd_emp = c.cd_emp AND 
			a.cd_tp_receita = c.cd_tp_receita 
		WHERE 
			a.cd_emp = in_cd_emp AND 
			a.cd_prod = var_in_cd_prod 
		LIMIT 1;

		EXCEPTION
		WHEN NO_DATA_FOUND THEN
	END;
	-- FIM CAPTURA DE CAMPANHA

	-- CAPTURANDO PARAMETROS DE CONFIGURAÇÃO
	var_is_agregar_desc_qtde       = COALESCE((SELECT 
												  COALESCE(CAST(valor AS integer), 0) 
												FROM 
													prc_emp_config 
												WHERE 
													cd_emp = in_cd_emp AND 
													cd_chave ILIKE 'AGREGAR_DESC_QTDE'), 0);
	var_agregar_desc_qtde_em       = COALESCE((SELECT 
													COALESCE(valor, '0') 
												FROM 
													prc_emp_config 
												WHERE 
													cd_emp = in_cd_emp 
													AND cd_chave ILIKE 'AGREGAR_DESC_QTDE_EM'), '0');
	var_valida_sts_cred_conv       = COALESCE((SELECT 
													COALESCE(CAST(valor AS integer), 1) 
												FROM 
													prc_emp_config 
												WHERE 
													cd_emp = in_cd_emp 
													AND cd_chave ILIKE 'VALIDA_STS_CRED_CONV'), 1);
	var_valida_sts_cred_crediario  = COALESCE((SELECT 
												COALESCE(CAST(valor AS integer), 1) 
											   FROM 
												prc_emp_config 
											   WHERE 
												cd_emp = in_cd_emp AND 
												cd_chave ILIKE 'VALIDA_STS_CRED_CREDIARIO'), 1);
	var_usa_cartao_para_fidelidade = COALESCE((SELECT 
												  COALESCE(CAST(valor AS integer), 0) 
											   FROM 
												  prc_emp_config 
											   WHERE 
													cd_emp = in_cd_emp AND 
													cd_chave ILIKE 'USA_CARTAO_PARA_FIDELIDADE'), 0);

	var_permite_desc_oferta = COALESCE((SELECT 
												  COALESCE(CAST(valor AS integer), 0) 
											   FROM 
												  prc_emp_config 
											   WHERE 
													cd_emp = in_cd_emp AND 
													cd_chave ILIKE 'PERMITIR_DESCONTO_EM_PRODUTO_OFERTA'), 0);
	
	-- CAPTURA SE CLIENTE E FIDELIDADE PARA VALIDAR PONTUACAO
	vr_pgto_avista = COALESCE((select 
								case when tp_cond =0 then 
									1 
								else 
									0 
								end
								from 
									est_forma_pgto 
								where 
									cd_frm_pgto=in_cd_frm_pgto 
									and sts_frm_pgto = 0
								limit 1),1);
	BEGIN
		SELECT  
			COALESCE(A.flag_cli_fidel, 0)
		INTO 
			STRICT var_is_cli_fidel
		FROM 
			rc_cli a 
		WHERE 
			a.cd_emp = in_cd_emp AND 
			a.cd_cli = in_cd_cli 
		LIMIT 1;

		EXCEPTION
		WHEN NO_DATA_FOUND THEN
	END;
	
	IF var_integra_pontuacao <= 1 THEN
		IF var_usa_cartao_para_fidelidade = 1 AND var_is_cli_fidel = 0 THEN
			IF btrim(in_nr_cartao_fidel, ' ') <> '' AND NOT in_nr_cartao_fidel IS NULL THEN
				var_is_cli_fidel = COALESCE((SELECT 
												1 
											FROM 
												rc_cli 
											WHERE 
												cd_emp = in_cd_emp AND 
												cd_cli = in_cd_cli AND 
												nr_cartao = in_nr_cartao_fidel
											limit 1),0);
			END IF;
		END IF;
	ELSE
		IF btrim(in_nr_cartao_fidel, ' ') <> '' AND NOT in_nr_cartao_fidel IS NULL THEN
			var_is_cli_fidel = 1;
		END IF;
	END IF;
	
	IF var_is_cli_fidel = 0 THEN
		var_qtde_ponto_fidel = 0;
	END IF;
	
	--CAPTURANDO PERCENTUAL DE DESCONTO LIMITE;
		var_perc_desc_limite = COALESCE((SELECT 
											COALESCE(perc_desc_limite,0) 
										FROM 
											ufd_est_prod_tbl_desc_limite(in_cd_emp, 
																		in_cd_filial, 
																		var_in_cd_prod)),0);

		var_perc_desc_pos_pbm = ufd_est_prod_tbl_desc_pos_pbm(in_cd_emp, in_cd_filial, var_in_cd_prod,in_usa_desconto_propz_ident);

-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
-- in_usa_desconto_propz_ident

	--CAPTURANDO VALOR OFERTA
	var_vlr_oferta = COALESCE((select case when (vr_pgto_avista = 1 and preco.vlr_oferta_avista > 0) then
									case when preco.vlr_oferta < preco.vlr_oferta_avista then 
										preco.vlr_oferta
									else 
										preco.vlr_oferta_avista  
									end 
								else 
									preco.vlr_oferta 
								end 
							from 
								est_prod_preco preco 
							where 
								in_cd_emp = preco.cd_emp AND 
								in_cd_filial = preco.cd_filial AND 
								var_in_cd_prod   = preco.cd_prod) ,0 );

	-- CONSULTA BASICA DE PRODUTO	
	INSERT INTO temp_rs_produto
	SELECT 
			in_cd_emp,
			in_cd_filial,
			var_in_cd_prod,
			LEFT(prod.ds_prod,100),
			LEFT(coalesce(est_prod_fabric.nm_fabric,'NAO DEFINIDO'),100) nm_fabric,
			preco.vlr_tabela,
			0,
			var_qtde_ponto_fidel,
			prod.ctr_pmc,
			COALESCE(COALESCE(prod_c.flag_verba_descon, prod.flag_verba_descon),0),
			prod.flag_requer_receit,
			prod.flag_alterar_preco,
			prod.prod_uso_cont,
			var_tp_prod,
			var_vlr_custo,
			0 , --CD_GRP grupo comissionamento verificar com pegar este valor
			var_qtd_ponto_venda, 
			var_lmt_prod_ponto_venda,
			COALESCE(prod_c.apres_qt_vd, 1),
			var_qtde_estoque, 
			var_ds_tipo_receita,
			var_ds_cor_receita,
			var_perc_desc_limite,
			trib.cd_trib_fc, 
			prod_c.perc_icms_n_cont_esta, 
			prod_c.perc_red_vd,
			1 , --libera_vd_conv
			-1 , --qtde_prod_max_conv
			COALESCE(prod.perc_desc_fix,0) , --fixa_desconto
			0 , --tp_desconto
			0 , --vlr_economia
			'', --ds_desconto
			0 , --cd_tbl_desc
			0 , --tp_nivel
			0 , --perc_desc
			0 , --perc_desc_max
			COALESCE(prod.controle_sngpc,0), -- flag_produto_controlado
			0 , --flag_desconto_ticket_blq,      
			0 , --perc_desc_fidel_max,        
			0 , --promo_industria,         
			0 , --perc_desc_aniver,      
			0 , --perc_desc_clas,     
			0 , --vlr_desc_fabric,		      
			0 , --campanha,      
			0 , --qtde_prod_campanha,   
			0 , --flag_bloqueia_desconto
			COALESCE(var_perc_desc_pos_pbm,0), -- perc_desc_pos_pbm
			var_cd_familia, -- codigo da familia
			prod.ncm_prod,
			prod.nr_reg_ms,
			prod.qtde_limite_venda,
			prod_c.perc_pis,
			prod_c.perc_cofins,
			coalesce(CAT.DS_ARV_MERC_CATEG,'PADRAO'),
			coalesce(CATSUB.DS_ARV_MERC_CATEG_SUB, 'PADRAO'),
			'PADRAO' AS unidade_medida,
			3 AS tp_tbl_desc , -- tp_tbl_desc  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
			var_dt_fim,
			var_qtde_limite_venda_familia --- qtde limite familia
			
	  FROM	est_prod prod INNER JOIN est_prod_cpl prod_c ON
			prod.cd_emp  = prod_c.cd_emp AND 
			prod.cd_prod = prod_c.cd_prod 
			LEFT JOIN est_prod_fabric on 
			prod.cd_fabric  = est_prod_fabric.cd_fabric 
			INNER JOIN est_prod_preco preco ON
			prod_c.cd_emp = preco.cd_emp AND 
			prod_c.cd_filial = preco.cd_filial AND 
			prod_c.cd_prod  = preco.cd_prod 
			inner join est_trib trib on 
			prod_c.cd_trib_vd = trib.cd_trib
			inner join est_prod_est_arv_mercadologica arv on arv.cd_emp  = prod.cd_emp
														 and arv.cd_prod = prod.cd_prod
			left join est_arv_merc_categoria as cat on arv.cd_emp = cat.cd_emp  
												   and arv.cd_arv_merc_categ            = cat.cd_arv_merc_categ 
            left join est_arv_merc_categoria_sub as catsub on arv.cd_emp                = catsub.cd_emp 
														  and arv.cd_arv_merc_categ     = catsub.cd_arv_merc_categ 
														  and arv.cd_arv_merc_categ_sub = catsub.cd_arv_merc_categ_sub  
	WHERE	
			prod.cd_emp = in_cd_emp 
			AND prod_c.cd_filial = in_cd_filial 
			AND prod.cd_prod = var_in_cd_prod
			AND prod_c.sts_prod <>1
			and prod.sts_prod <>1
			AND preco.vlr_tabela > 0;
	
	
	
	
	IF NOT EXISTS (SELECT
		     			cd_prod 
		    	   FROM
		      			temp_rs_produto
	           	   LIMIT 1)  THEN -- VERIFICA SE EXISTE PRODUTO
				   
				   
		var_motivo_sts_prod = 'Produto não encontrado ou inativo, analise o cadastro do mesmo.' || E'\n\n'; 	

		var_motivo_sts_prod = var_motivo_sts_prod || 'Motivo'; 
		var_motivo_sts_prod = var_motivo_sts_prod  || coalesce((select E'\n'|| ds_motivo_sts from est_prod_cpl a
				where a.cd_emp = in_cd_emp and a.cd_filial = in_cd_filial and a.cd_prod = var_in_cd_prod), '');
				
		var_motivo_sts_prod = var_motivo_sts_prod || coalesce((select E'\n' || ds_motivo_sts from est_prod a
				where a.cd_emp = in_cd_emp and a.cd_prod = var_in_cd_prod), '');
		
		RAISE EXCEPTION '%', var_motivo_sts_prod ;
	END IF; 
	
	
	-- Busccando limite de venda do produto 								
	var_qtde_limite_venda = (select qtde_limite_venda 
                              from temp_rs_produto 
                             -- where cd_emp  = in_cd_emp 
                             -- and cd_prod   = var_in_cd_prod 
							 -- and cd_filial = in_cd_filial
							   );		   
	 If (var_qtde_limite_venda > 0) then 
		if (in_qtde_prod > var_qtde_limite_venda ) then
			RAISE EXCEPTION ' Atenção!  Produto: % com limite de venda de até  % unidades     ', in_cd_prod,var_qtde_limite_venda;
		end if ;  
     end if ;  
	
	
-- ::::::::::::VALIDANDO VENDA DO PRODUTO EM CONVENIO --inicio ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::	
	 
	var_in_cd_conv =0;
	var_libera_vd_conv = 1;
	
	IF in_cd_conv >0 THEN
		var_in_cd_conv = in_cd_conv;
		var_libera_vd_conv = ufd_est_prod_libera_pgto_conv(in_cd_emp, 
													   in_cd_filial, 
													   var_in_cd_prod, 
													   in_cd_cli, 
													   var_in_cd_conv, 
													   in_is_receita);
	END IF;	

-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::	
/* Validacao de bloqueamento de desconto para convenio */

--	IF (var_libera_vd_conv = 1) THEN
--	    RAISE EXCEPTION 'Produto % bloqueado para venda para convenio %.', var_in_cd_prod, in_cd_conv;
--	END IF;
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::	

		var_vlr_tabela = COALESCE((select COALESCE(vlr_tabela, 0) from temp_rs_produto) ,0 );
	

		insert into temp_rs_tipo_desc_cad
		select cd_tp_desconto from est_prod_tbl_desc group by cd_tp_desconto;
		
		-- var_is_orcamento_antigo = 1 Orçamento Antigo | 0  Orçamento Novo 
		var_is_orcamento_antigo = COALESCE((select coalesce(valor,'0')::integer from prc_filial_config where LOWER(cd_chave) = LOWER('FILIAL_UTILIZA_ORC_ANTIGO') limit 1),0)::integer;

		
		IF (var_is_orcamento_antigo = 0) THEN
			insert into temp_rs_tipo_desc_cad
			select cd_tp_desconto from est_prod_tbl_desc_qtde where cd_tp_desconto <> 24 group by cd_tp_desconto;
		ELSE
			insert into temp_rs_tipo_desc_cad
			select cd_tp_desconto from est_prod_tbl_desc_qtde group by cd_tp_desconto;
		END IF;
		
		insert into temp_rs_tipo_desc_cad
		select 25 from est_prod_tbl_desc_cargo;

		IF EXISTS (SELECT 1 
		                FROM 
							est_prod_cd_barra 
					   WHERE 
							cd_emp = in_cd_emp AND 
					        cd_barra = tmp_cd_barra and flag_pre_vencidos = 1) 
         --Gustavo Postigo 03/01/2022 - PRE_VENCIDO_VALIDA_MELHOR_DESCONTO
         AND COALESCE( ( select valor
                           from prc_emp_config
                           where cd_emp = 1
                              and cd_chave ILIKE 'PRE_VENCIDO_VALIDA_MELHOR_DESCONTO'
                           limit 1  ) , '0' ) = '0'							
          
      THEN								
							
			--CAPTURANDO DESCONTO DE PREVENCIDOS
			INSERT INTO temp_rs_tab_desc
			SELECT 
				  cd_tbl_desc,
				  26 tp_desc,
				  0 flag_desc_fix,
				  COALESCE(perc_desc,0), 
				  COALESCE(perc_desc_max), 
				  tp_nivel,
				  0   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
				FROM ufd_est_prod_tbl_desc_pre_vencidos (in_cd_emp,
														in_cd_filial,
														tmp_cd_barra,
														in_cd_frm_pgto -- ,in_cd_frm_pgto // ADICIONADO PELO RC em 10.02.23
														);
							
        ELSE							

/************************************************************************************************/
         --Gustavo Postigo 03/01/2022 - PRE_VENCIDO_VALIDA_MELHOR_DESCONTO
		   IF EXISTS (SELECT 1 
		                     FROM 
							   est_prod_cd_barra 
					      WHERE 
							   cd_emp = in_cd_emp AND 
					            cd_barra = tmp_cd_barra and flag_pre_vencidos = 1)
            AND COALESCE( ( select valor
                              from prc_emp_config
                              where cd_emp = 1
                                 and cd_chave ILIKE 'PRE_VENCIDO_VALIDA_MELHOR_DESCONTO'
                              limit 1  ) , '0' ) = '1'
         THEN
							
							
			   --CAPTURANDO DESCONTO DE PREVENCIDOS
			   INSERT INTO temp_rs_tab_desc
			   SELECT 
				      cd_tbl_desc,
				      26 tp_desc,
				      0 flag_desc_fix,
				      perc_desc, 
				      perc_desc_max, 
				      tp_nivel,
						0   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
				   FROM ufd_est_prod_tbl_desc_pre_vencidos2 (in_cd_emp,
														   in_cd_filial,
														   tmp_cd_barra); --ADICIONADO PELO SUPORTE
            
         END IF;
/*****************************************************************************************************/
			 
			-- CALCULAR PRECO OFERTA
			IF var_vlr_oferta > 0 THEN
				var_perc_desc_oferta = round( ((1 - var_vlr_oferta / var_vlr_tabela) * 100)::numeric , 4); 
				var_perc_desc_oferta_max = case var_permite_desc_oferta when 1 then var_perc_desc_oferta + 0.01 else var_perc_desc_oferta end;
				
				INSERT INTO temp_rs_tab_desc
				SELECT 0, 6, 1, var_perc_desc_oferta, var_perc_desc_oferta_max, 1
						, 0;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
			END IF;
		
			IF EXISTS (SELECT * FROM EST_PROD_PRECO WHERE CD_EMP = in_cd_emp and CD_FILIAL = in_cd_filial 
										AND CD_PROD = var_in_cd_prod 
										AND (coalesce(flag_sobrepoe_descontos,0)  <> 1 OR vlr_oferta = 0)) THEN
										
				IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto > 0) THEN
					 
					IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 28) THEN
					-- CAPTURANDO DESCONTO	POR CLIENTE ESPECIAL 
					INSERT INTO temp_rs_tab_desc
					SELECT 
						cd_tbl_desc,
						tp_desc,
						flag_desc_fix, 
						COALESCE(perc_desc,0),
						COALESCE(perc_desc_max,0), 
						tp_nivel,
						0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
						dt_fim
						
					FROM ufd_est_prod_tbl_desc_especial_cliente(in_cd_emp,in_cd_filial, var_in_cd_prod, in_cd_cli,in_usa_desconto_propz_ident);
					
					END IF;

-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
-- in_usa_desconto_propz_ident

					IF (in_cd_frm_pgto = (SELECT CD_FRM_PGTO FROM est_forma_pgto WHERE DS_FRM_PGTO ILIKE 'CRED%' and  sts_frm_pgto = 0 limit 1) OR in_cd_frm_pgto = (SELECT CD_FRM_PGTO FROM est_forma_pgto WHERE DS_FRM_PGTO ILIKE 'CONV%' and  sts_frm_pgto = 0 LIMIT 1) or in_cd_frm_pgto = 0) THEN
						var_desconto_especial = COALESCE((SELECT 2 -- CREDIARIO
															 FROM 
																est_forma_pgto a INNER JOIN est_forma_pgto_moeda b ON  
																a.cd_emp = b.cd_emp AND 
																a.cd_frm_pgto = b.cd_frm_pgto 
															WHERE 
																a.cd_frm_pgto = in_cd_frm_pgto AND 
																b.cd_tp_moeda = 5 
															  and  sts_frm_pgto = 0
															LIMIT 1), 3);									
						IF var_desconto_especial = 2 THEN
							IF NOT (COALESCE((SELECT 
												1 
											   FROM 
												est_forma_pgto a 
											   where 
												a.cd_frm_pgto = in_cd_frm_pgto and 
												a.regra_desconto = 2 
												and  sts_frm_pgto = 0
											 LIMIT 1), 0) = 1 OR
									COALESCE((SELECT 
												1 
											  FROM 
												rc_mdl_venda a 
											where 
												a.cd_mdl_vd = var_cd_mdl_vd_crediario and 
												flag_somente_desc_contrato = 1 
											LIMIT 1), 0) = 1) THEN
								var_desconto_especial = 3;
							END IF;
						END IF;			
						
						IF var_desconto_especial = 3 THEN
							var_desconto_especial = COALESCE((SELECT 
																1 -- CONVENIO
															FROM 
																est_forma_pgto a INNER JOIN est_forma_pgto_moeda b ON  
																a.cd_emp = b.cd_emp AND 
																a.cd_frm_pgto = b.cd_frm_pgto 
															WHERE 
																a.cd_frm_pgto = in_cd_frm_pgto AND 
																b.cd_tp_moeda = 4 
																and  sts_frm_pgto = 0
															LIMIT 1),3);
								--Regra de desconto = 1-CONVENIO								
							IF var_desconto_especial = 1 THEN
								IF NOT (COALESCE((SELECT 
													1 
												  FROM 
													est_forma_pgto a 
												where 
													a.cd_frm_pgto = in_cd_frm_pgto and 
													a.regra_desconto = 1 
													and  sts_frm_pgto = 0
												LIMIT 1), 0) = 1 OR
										 COALESCE((SELECT 
														1 
												   FROM 
													  rc_cli_conv a 
													where 
														a.cd_conv = var_in_cd_conv and 
														flag_somente_desc_contrato = 1 
													LIMIT 1), 0) = 1 OR
										COALESCE((SELECT 
													1 
												  FROM 
													rc_mdl_venda a 
												where 
													a.cd_mdl_vd = var_cd_mdl_vd_convenio and 
													flag_somente_desc_contrato = 1 
												LIMIT 1), 0) = 1) THEN
									var_desconto_especial = 3;
								END IF;
							END IF;
						END IF;
						
						IF var_desconto_especial = 3 THEN
							var_desconto_especial = COALESCE((SELECT 
																0 
															 FROM 
																est_forma_pgto a 
															 where 
																a.cd_frm_pgto = in_cd_frm_pgto and 
																a.regra_desconto = 0 
																and  sts_frm_pgto = 0
															LIMIT 1), 3);
						END IF;
						ELSE
						BEGIN
							--PRINT 'VERIFICANDO DESCONTO SOMENTE CONVENIO B'
							IF  (COALESCE((SELECT 1 FROM RC_CLI_CONV A WHERE CD_CONV = in_cd_conv AND var_somente_desc_convenio = 1 limit 1), 0) = 1) 
							THEN
								var_desconto_especial = 1;
							END IF;
						END;
					END IF;

					-- CAPTURANDO DESCONTO DE FORMA DE PAGAMENTO
					IF var_desconto_especial = 3 OR var_desconto_especial = 0 THEN
						IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 18) THEN
							IF in_cd_frm_pgto > 0 THEN
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									perc_desc, 
									perc_desc_max, 
									tp_nivel,
									0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									dt_fim
								FROM 
									ufd_est_prod_tbl_desc_forma_pgto(in_cd_emp, 
																	 in_cd_filial, 
																	 var_in_cd_prod, 
																	 in_cd_frm_pgto, 
																	 in_is_receita,
																	 in_usa_desconto_propz_ident);
							END IF;
						END IF;
					END IF; -- FIM CAPTURANDO DESCONTO DE FORMA DE PAGAMENTO

-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
-- in_usa_desconto_propz_ident

					-- CAPTURANDO DESCONTO DE CONVENIO
					IF var_desconto_especial = 3 OR var_desconto_especial = 1	 THEN
						
						
						IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 3) THEN
						-- VERIFICA SE VALIDA STATUS DE CREDITO PARA CONCEDER DESCONTO
							IF in_cd_conv > 0 THEN	
								IF NOT EXISTS(SELECT 
												1 
											 FROM 
												rc_cli_conv_rc_cli 
											 WHERE 
												cd_emp = in_cd_emp 
												AND cd_conv = in_cd_conv 
												AND cd_cli = in_cd_cli 
												AND sts_ativo = 0) THEN
									var_in_cd_conv = 0;
								ELSE
									IF var_valida_sts_cred_conv > 0 AND in_cd_conv > 0 THEN
										IF NOT EXISTS(SELECT 
														1 
													  FROM 
														rc_cli_conv_rc_cli 
													WHERE 
														cd_emp = in_cd_emp 
														AND cd_conv = in_cd_conv 
														AND cd_cli = in_cd_cli 
														AND sts_cred = 0
													LIMIT 1) THEN
											var_in_cd_conv = 0;
										END IF;
									END IF;
									 
									IF (in_cd_frm_pgto = (SELECT CD_FRM_PGTO FROM est_forma_pgto WHERE DS_FRM_PGTO ILIKE 'CONV%' and  sts_frm_pgto = 0 LIMIT 1) or in_cd_frm_pgto = 0) THEN 
									BEGIN
										IF var_in_cd_conv > 0 THEN
										 
											--IF (var_libera_vd_conv = 1) THEN
											 --  RAISE EXCEPTION 'Produto % bloqueado para venda para convenio %.', var_in_cd_prod, in_cd_conv; -- ALTERADO PARA 1
										--END IF;
										
										BEGIN
											SELECT  cd_tbl_desc,
													tp_desc,
													COALESCE(perc_desc,0),
													case var_somente_desc_convenio when 1 then perc_desc_max else perc_desc_max + 0.01 end,
													tp_nivel,
													exclue_oferta,
													qt_max  
											INTO STRICT var_cd_tbl_desc,
														var_tp_desc,
														var_perc_desc,
														var_perc_desc_max,
														var_tp_nivel,
														var_exclue_oferta,
														var_qt_max
											FROM ufd_est_prod_tbl_desc_conv(in_cd_emp, 
																			in_cd_filial, 
																			var_in_cd_prod, 
																			in_cd_cli, 
																			var_in_cd_conv, 
																			in_is_receita, 
																			var_libera_vd_conv, 
																			in_cd_frm_pgto,
																			in_usa_desconto_propz_ident);

											raise notice 'var_libera_vd_conv %', var_libera_vd_conv;
											IF (var_somente_desc_convenio = 1) THEN 
												var_desconto_especial = 1;
											END IF;
											-- INSERINDO DESCONTO DE CONVENIO
											INSERT INTO 
												temp_rs_tab_desc
											SELECT  
												var_cd_tbl_desc,
												var_tp_desc,
												var_flag_desc_fix,
												var_perc_desc,
												var_perc_desc_max,
												var_tp_nivel,
												0;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto) 
											
											-- SETANDO SE PRODUTO PODE SER VENDIDO EM CONVENIO E QUANTIDADE MAXIMA NO CONVENIO
											var_somente_desc_convenio= coalesce((select 
																					FLAG_SOMENTE_DESC_CONTRATO 
																				from 
																					rc_cli_conv 
																				where 
																					cd_emp = in_cd_emp and 
																					cd_conv  = in_cd_conv
																				limit 1),0);
											
											UPDATE 
												temp_rs_produto 
											SET 
												libera_vd_conv = var_libera_vd_conv, 
												qtde_prod_max_conv = var_qt_max,
												lib_desc_verba = case when var_somente_desc_convenio = 1 and in_cd_frm_pgto != 1 then 
																	1
																 else 
																	lib_desc_verba 
																end;
											EXCEPTION
												WHEN NO_DATA_FOUND THEN
											END;	
										END IF;	
									END;									
									END IF;
								END IF;
							END IF;
						END IF;
					END IF; -- FIM CAPTURANDO DESCONTO DE CONVENIO
					
					--Nao respeita o contrato de convenio
					--Entrada na melhor condicao para o cliente
							IF var_desconto_especial = 3 OR var_desconto_especial = 2 THEN
								IF var_cli_crediario = 1 THEN
									IF var_cd_mdl_vd_crediario > 0 THEN
									IF ((SELECT cd_frm_pgto FROM est_forma_pgto WHERE ds_frm_pgto ILIKE 'CRED%' and  sts_frm_pgto = 0 LIMIT 1) = in_cd_frm_pgto or in_cd_frm_pgto = 0) THEN 
										IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 19) THEN		
											IF var_valida_sts_cred_crediario > 0 THEN -- VALIDA ESTADOS DE CREDITO 
												IF EXISTS(SELECT 
																1 
														  FROM 
															rc_cli_crediario 
														WHERE 
															cd_emp = in_cd_emp AND 
															cd_cli  = in_cd_cli AND 
															(sts_cred <> 0 OR cd_mdl_vd < 1) ) THEN
													var_cli_crediario = 0;
												END IF;
											END IF;
											
											IF var_cli_crediario  = 1 THEN -- BUSCANDO DESCONTO
												INSERT INTO temp_rs_tab_desc
												SELECT 
													cd_tbl_desc, 
													tp_desc, 
													flag_desc_fix, 
													COALESCE(perc_desc,0), 
													COALESCE(perc_desc_max,0), 
													tp_nivel,
													0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
													dt_fim													
												from ufd_est_prod_tbl_desc_crediario(in_cd_emp, 
																					 in_cd_filial, 
																					 var_in_cd_prod, 
																					 var_cd_mdl_vd_crediario, 
																					 in_is_receita, 
																					 in_cd_frm_pgto,
																					 in_usa_desconto_propz_ident);
											END IF;
										END IF;
									END IF;
									END IF;
								END IF;
							END IF;


						RAISE NOTICE 'var_desconto_especial %', var_desconto_especial;
						IF var_desconto_especial = 3 THEN
						
							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 1) THEN
 						
							-- CAPTURANDO DESCONTO DE PRODUTO
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									dt_fim
								  FROM ufd_est_prod_tbl_desc_cadastro_prod(in_cd_emp, 
																		   in_cd_filial, 
																		   var_in_cd_prod, 
																		   in_is_receita, 
																		   in_cd_frm_pgto,
																		   in_usa_desconto_propz_ident);
							END IF;


							IF (EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 3) AND (var_in_cd_conv > 0) AND (in_cd_cli > 0))THEN
							BEGIN
								SELECT  cd_tbl_desc,
										tp_desc,
										COALESCE(perc_desc,0),
										case var_somente_desc_convenio when 1 then perc_desc_max else perc_desc_max + 0.01 end,
										tp_nivel,
										qt_max  
								INTO STRICT var_cd_tbl_desc,
											var_tp_desc,
											var_perc_desc,
											var_perc_desc_max,
											var_tp_nivel,
											var_qt_max
								FROM ufd_est_prod_tbl_desc_conv(in_cd_emp, 
																in_cd_filial, 
																var_in_cd_prod, 
																in_cd_cli, 
																var_in_cd_conv, 
																in_is_receita, 
																var_libera_vd_conv,					in_cd_frm_pgto,
																in_usa_desconto_propz_ident); --add pelo RC em 10-02-23
																	
								var_somente_desc_convenio= coalesce((select 
																		FLAG_SOMENTE_DESC_CONTRATO 
																	from 
																		rc_cli_conv 
																	where 
																		cd_emp = in_cd_emp and 
																		cd_conv  = in_cd_conv
																	limit 1),0);
																	
										
								UPDATE 
									temp_rs_produto 
								SET 
									libera_vd_conv = var_libera_vd_conv, 
									qtde_prod_max_conv = var_qt_max,
									lib_desc_verba = case when var_somente_desc_convenio = 1 and in_cd_frm_pgto != 1 then 
														1
													 else 
														lib_desc_verba 
													end;
												
								INSERT INTO 
									temp_rs_tab_desc
								SELECT  
									var_cd_tbl_desc,
									var_tp_desc,
									var_flag_desc_fix,
									var_perc_desc,
									var_perc_desc_max,
									var_tp_nivel,
									0;  -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									EXCEPTION
										WHEN NO_DATA_FOUND THEN
							END;
							END IF;
																			
							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 4) THEN
								-- CAPTURANDO DESCONTO DE FIDELIDADE
								IF var_is_cli_fidel = 1 THEN
									INSERT INTO temp_rs_tab_desc
									SELECT 
										cd_tbl_desc, 
										tp_desc, 
										flag_desc_fix, 
										COALESCE(perc_desc,0), 
										COALESCE(perc_desc_max,0), 
										tp_nivel,
										0,  -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
										dt_fim
									FROM ufd_est_prod_tbl_desc_fidelidade(in_cd_emp, 
																		  in_cd_filial, 
																		  var_in_cd_prod, 
																		  in_cd_cli, 
																		  in_is_receita, 
																		  in_cd_frm_pgto,
																		  in_usa_desconto_propz_ident);
								END IF;
							END IF;


							IF EXISTs(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto =25) THEN
								--CAPTURANDO DESCONTO DE CARGO
								INSERT INTO temp_rs_tab_desc
								SELECT 
									  cd_tbl_desc_cargo,
									  25 tp_desc,
									  0 flag_desc_fix,
									  0 perc_desc, 
									  perc_desc perc_desc_max, 
									  tp_nivel_perc,
									  0   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									FROM ufd_est_prod_desc_funcionario_cargo (in_cd_emp,
																	  in_cd_filial,
																	  var_in_cd_prod,
																	  in_cd_vend );
							END IF;

							
							
							if(in_application != 3 and var_is_orcamento_antigo = 1) then
								IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 24) THEN
									-- CAPTURANDO DESCONTO DE PAGE LEVE
									var_cd_tbl_desc = -1;
								
								
									IF in_qtde_prod > 1 THEN
										BEGIN
											SELECT  cd_tbl_desc_qtde,
													tp_desc         ,
													qtde_pag        ,
													0           	,
													COALESCE(perc_desc,0)		,
													COALESCE(perc_desc_max,0)	,
													tp_nivel        ,
													agregacao 
											INTO STRICT var_cd_tbl_desc   ,
														var_tp_desc       ,
														var_qtde_pag      ,
														var_flag_desc_fix ,
														var_perc_desc     ,
														var_perc_desc_max ,
														var_tp_nivel      ,
														var_agregacao
											FROM ufd_est_prod_tbl_desc_leve_pague(in_cd_emp, in_cd_filial
																				  , var_in_cd_prod, cast(in_qtde_prod as integer)
																				  , in_cd_frm_pgto,in_usa_desconto_propz_ident);
	
											EXCEPTION
											WHEN NO_DATA_FOUND THEN
										END;	


										IF var_cd_tbl_desc > -1 THEN
											if in_application != 3 and var_agregacao = 1 then	
												UPDATE 
													temp_rs_tab_desc 
												SET
													perc_desc 		= ROUND(((var_qtde_pag * COALESCE(perc_desc,0) + (in_qtde_prod - var_qtde_pag) * 100) / in_qtde_prod)::NUMERIC, 4),
													perc_desc_max 	= ROUND((( var_qtde_pag * COALESCE(perc_desc_max,0) + (in_qtde_prod - var_qtde_pag)* 100.) / in_qtde_prod)::numeric, 4),
													tp_tbl_desc = 1;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
											end if;			

											INSERT INTO temp_rs_tab_desc
											SELECT  var_cd_tbl_desc   ,
													var_tp_desc       ,
													var_flag_desc_fix ,
													var_perc_desc     ,
													var_perc_desc_max ,
													var_tp_nivel, 
													1;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																										
										END IF;
									END IF;
								END IF;
							END IF;
						 
	
							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 11) THEN
								-- CAPTURANDO DESCONTO DE ANIVERSARIO		
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									dt_fim
								  FROM ufd_est_prod_tbl_desc_aniversario(in_cd_emp, 
																		 in_cd_filial, 
																		 var_in_cd_prod, 
																		 in_cd_cli, 
																		 in_is_receita, 
																		 in_cd_frm_pgto,
																		 in_usa_desconto_propz_ident);
							END IF;

							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 12) THEN
								-- CAPTURANDO DESCONTO DE CLASSIFICACAO CLIENTE
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									dt_fim
								  FROM ufd_est_prod_tbl_desc_classificacao(in_cd_emp, 
																		   in_cd_filial, 
																		   var_in_cd_prod, 
																		   in_cd_cli, 
																		   in_is_receita, 
																		   in_cd_frm_pgto,
																		   in_usa_desconto_propz_ident);
							END IF;
	
	
							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 23) THEN
								-- CAPTURANDO DESCONTO DE PROGRAMADO
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									dt_fim
								FROM ufd_est_prod_tbl_desc_programado(in_cd_emp, 
																	  in_cd_filial, 
																	  var_in_cd_prod, 
																	  in_is_receita, 
																	  in_cd_frm_pgto,
																	  in_usa_desconto_propz_ident);
							END IF;
							

							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 15) THEN
								-- CAPTURANDO DESCONTO DE TELEVENDAS
								IF in_application = 1 THEN
									INSERT INTO temp_rs_tab_desc
									SELECT 
										cd_tbl_desc, 
										tp_desc, 
										flag_desc_fix, 
										COALESCE(perc_desc,0), 
										COALESCE(perc_desc_max,0), 
										tp_nivel,
										0,   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
										dt_fim
									FROM 
										ufd_est_prod_tbl_desc_televendas(in_cd_emp, 
																		 in_cd_filial, 
																		 var_in_cd_prod, 
																		 in_is_receita, 
																		 in_cd_frm_pgto,
																		 in_usa_desconto_propz_ident);
								END IF;
							END IF;


							IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 13) THEN
								-- CAPTURANDO DESCONTO DE FABRICA
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
								FROM 
									ufd_est_prod_tbl_desc_preco_fabrica(in_cd_emp, 
																		in_cd_filial, 
																		in_cd_cli, 
																		var_in_cd_prod, 
																		in_cd_frm_pgto);
							END IF;
		 
		 
		 
							raise notice 'in_cd_parceiro = %.',in_cd_parceiro;
							
							if ( in_cd_parceiro > 0 )  then 

							-- verifica se o parceiro usa tabelas exclusivas 0 - Não | 1 - Sim 
							var_usa_desc_exclusivo = coalesce(( select desc_exclusivo_parceiro from glb_parceiro where cd_parceiro = in_cd_parceiro ), 0);
							raise notice 'var_usa_desc_exclusivo = %.',var_usa_desc_exclusivo;
							
							
														
							-- verifica se existe alguma tabela exclusiva configurada  0 - Nao | 1 - Sim 
							var_tabelas_exclusivas = coalesce(( select 1 from glb_parceiro_est_prod_tbl_desc where cd_parceiro = in_cd_parceiro limit 1  ), 0);
							raise notice 'var_tabelas_exclusivas = %.',var_tabelas_exclusivas;

								
								IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 31) THEN
								-- CAPTURANDO DESCONTO PARCEIRO
								INSERT INTO temp_rs_tab_desc
								SELECT 
									cd_tbl_desc, 
									tp_desc, 
									flag_desc_fix, 
									COALESCE(perc_desc,0), 
									COALESCE(perc_desc_max,0), 
									tp_nivel,
									0   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
								FROM 
									ufd_est_prod_tbl_desc_parceiro(in_cd_emp, in_cd_filial, in_cd_parceiro, var_in_cd_prod, in_is_receita,in_usa_desconto_propz_ident);
								END IF;
								
							END IF;
-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
-- in_usa_desconto_propz_ident			 
		 
		 
		 
                if(in_application != 3 and var_is_orcamento_antigo = 1) then
				IF EXISTS(SELECT * FROM temp_rs_tipo_desc_cad WHERE cd_tp_desconto = 14) THEN
								-- CAPTURANDO DESCONTO DE QUANTIDADE ACIMA

								 var_cd_tbl_desc = -1;
							     begin 
									  SELECT  cd_tbl_desc,
											  tp_desc,
											  flag_desc_fix,
											  COALESCE(perc_desc,0), 
												COALESCE(perc_desc_max,0),
											  tp_nivel,
											  agregacao
										INTO STRICT var_cd_tbl_desc   ,
													var_tp_desc       ,
													var_flag_desc_fix ,
													var_perc_desc     ,
													var_perc_desc_max ,
													var_tp_nivel      ,
													var_agregacao
								        FROM ufd_est_prod_tbl_desc_qtde(in_cd_emp, 
																        in_cd_filial, 
																        in_cd_cli, 
																        var_in_cd_prod, 
																        in_qtde_prod, 
																        in_is_receita, in_cd_frm_pgto,in_usa_desconto_propz_ident);
						 			     EXCEPTION
											  WHEN NO_DATA_FOUND THEN

-- select * from p_est_prod_descontos(1, 18, 13492, 0 , '0', 1, 1 , 1, 0, 0, 0,0,0,0,0)	---=15 parâm  
-- in_usa_desconto_propz_ident	

							       end;
								       IF var_cd_tbl_desc > -1 THEN
										 if in_application != 3 and var_agregacao = 1 then
												
												UPDATE 
													   temp_rs_tab_desc 
												   SET perc_desc      =100-((100-(100*perc_desc/100))-((100-(100*perc_desc/100))*(var_perc_desc/100))),
												       perc_desc_max  =100-((100-(100*perc_desc_max/100))-((100-(100*perc_desc_max/100))*(var_perc_desc_max/100))),
														 tp_tbl_desc = 0;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
													   --perc_desc 		= perc_desc+var_perc_desc,
													   --perc_desc_max 	= perc_desc_max + var_perc_desc_max;
											 end if;			

											INSERT INTO temp_rs_tab_desc
											SELECT  var_cd_tbl_desc   ,
													var_tp_desc       ,
													var_flag_desc_fix ,
													var_perc_desc     ,
													var_perc_desc_max ,
													var_tp_nivel,
													0;   -- tp_tbl_desc  -- ( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
									END IF;
								END IF;					
							END if;
						END IF;
					--BAIXANDO DESCONTO SUPERIOR AO LIMITE FOI REMOVIDO
				END IF;
			END IF;
		END IF;

raise notice 'var_somente_desc_convenio = %.' ,var_somente_desc_convenio;

	--PEGANDO O MAIOR DESCONTO POSSIVEL
	BEGIN
	if var_somente_desc_convenio = 1  then 
		SELECT  cd_tbl_desc,
				tp_desc,
				flag_desc_fix,
				perc_desc_max,
				tp_nivel,
				--tp_tbl_desc,
				dt_fim,
				tp_tbl_desc
		INTO 
			STRICT var_cd_tbl_desc,
			var_tp_desc,
			var_flag_desc_fix,					
			var_perc_desc_max,
			var_tp_nivel,
			var_dt_fim,
			var_tp_tbl_desc
		FROM 
			temp_rs_tab_desc 
        where tp_desc = 3 		
		ORDER BY 
			perc_desc DESC, 
			perc_desc_max DESC,
			tp_nivel DESC 
		LIMIT 1; 
		
	else 
	
		 if ( in_cd_parceiro > 0 and var_usa_desc_exclusivo = 1 )  then 
		 
			select  cd_tbl_desc,
					tp_desc,
					flag_desc_fix,
					perc_desc_max,
					tp_nivel,
					dt_fim,					
					tp_tbl_desc
			    into 
			       	strict var_cd_tbl_desc,
			       	var_tp_desc,
			       	var_flag_desc_fix,					
			       	var_perc_desc_max,
			       	var_tp_nivel,					
			       	var_dt_fim,
					var_tp_tbl_desc
			 from temp_rs_tab_desc 
		    where tp_desc = 31 
			order by 
				perc_desc desc, 
				perc_desc_max desc,
				tp_nivel desc 
				
			limit 1;
			
			else 
							
				SELECT  cd_tbl_desc,
						tp_desc,
						flag_desc_fix,
						perc_desc_max,
						tp_nivel,
						dt_fim,
						tp_tbl_desc
				INTO 
					STRICT var_cd_tbl_desc,
					var_tp_desc,
					var_flag_desc_fix,					
					var_perc_desc_max,
					var_tp_nivel,
					var_dt_fim,
					var_tp_tbl_desc
				FROM 
					temp_rs_tab_desc 
				
				ORDER BY 
					perc_desc DESC, 
					perc_desc_max DESC,
					tp_nivel DESC 
				LIMIT 1; 
			
			
		  end if; 
	end if; 
 
	
	
	
		EXCEPTION
		WHEN NO_DATA_FOUND THEN
	END;	
	
	
	--PEGANDO O DESCONTO INICIAL DO CLIENTE		
	BEGIN
		SELECT  
			COALESCE(perc_desc,0)			 
		INTO 
			STRICT var_perc_desc     
		FROM 
			temp_rs_tab_desc 
		--where 
			--perc_desc <= var_perc_desc_max
		ORDER BY 
			perc_desc DESC, 
			tp_nivel DESC 
		LIMIT 1; 
		EXCEPTION
		WHEN NO_DATA_FOUND THEN
	END;

--Correcoes de descontos
	/* Nao limitar descontos Convenio ou Oferta ou Pre-fatura*/
	--((@TP_DESC in (3,6,26) OR @FLAG_SOMENTE_DESCONTO_CONV = 1 AND @TP_DESC = 3) and @PERC_DESC_LIMITE < @PERC_DESC_MAX)
	IF ((SELECT tp_desc FROM temp_rs_tab_desc ORDER BY perc_desc DESC, tp_nivel DESC LIMIT 1) in (3,4,6,14,23,24,26) AND var_perc_desc_limite < var_perc_desc_max) THEN
		IF (var_perc_desc_limite = 0) THEN
			var_perc_desc_limite = 100;
		ELSE
			var_perc_desc_limite = var_perc_desc_max;
		END IF;
	END IF;
	 
	
	var_perc_desc_limite 	= CASE var_perc_desc_limite WHEN 0 THEN 100 ELSE var_perc_desc_limite END;
	var_perc_desc_max 	 	= CASE WHEN var_perc_desc_max = 0 THEN var_perc_desc
								WHEN var_perc_desc_max > var_perc_desc_limite THEN var_perc_desc_limite 
								ELSE var_perc_desc_max END;
	var_perc_desc 			= CASE WHEN var_perc_desc > var_perc_desc_max THEN var_perc_desc_max ELSE var_perc_desc END;

	UPDATE temp_rs_produto SET		
		tp_desconto   = var_tp_desc,
		vlr_economia  = (vlr_tabela * (var_perc_desc / 100)),
		ds_desconto   = (SELECT ufd_descricao_desc FROM ufd_descricao_desc(var_tp_desc,var_cd_tbl_desc,var_tp_nivel)),	
		cd_tbl_desc   = var_cd_tbl_desc,
		tp_nivel      = var_tp_nivel,
		perc_desc     = var_perc_desc,
		perc_desc_max = var_perc_desc_max,
		perc_desc_limite = var_perc_desc_limite,
		libera_vd_conv = var_libera_vd_conv,
		dt_fim		  = var_dt_fim,
		tp_tbl_desc = var_tp_tbl_desc;
		
	IF (((SELECT 1 FROM temp_rs_produto WHERE perc_desc < 0) = 1 )or ((select tp_prod from est_prod_cpl where cd_emp = in_cd_emp and cd_filial = in_cd_filial and cd_prod = var_in_cd_prod) <> 0)) THEN
		
		UPDATE temp_rs_produto SET	
			tp_desconto   = 0,
			vlr_economia  = 0,
			ds_desconto   = 'Sem desconto sem definição de nivel',	
			cd_tbl_desc   = 0,
			tp_nivel      = 0,
			perc_desc     = 0,
			perc_desc_max = 0,
			libera_vd_conv = var_libera_vd_conv,
			tp_tbl_desc = 3;
	END IF;
		

	-- RETORNANDO DESCONTO
	FOR returnRec IN 
	
		SELECT '25/01/2023 00:00' as versao,* FROM temp_rs_produto
	LOOP
		RETURN NEXT returnRec;
	END LOOP;



END;
-- fim bloco principal

$BODY$;


ALTER FUNCTION public.p_est_prod_descontos(integer, integer, double precision, integer, character varying, integer, integer, double precision, integer, double precision, integer, integer, integer, integer, integer)
    OWNER TO postgres;
	


CREATE OR REPLACE FUNCTION public.p_est_prod_descontos(
    integer,
    integer,
    double precision,
    integer,
    character varying,
    integer,
    integer,
    double precision,
    integer,
    double precision,
    integer,
    integer)
  RETURNS SETOF rs_produto AS
$BODY$
	DECLARE 
	returnRec rs_produto;
BEGIN
	 returnRec = p_est_prod_descontos($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,0);
	 RETURN NEXT returnRec;
END;
-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.p_est_prod_descontos(integer, integer, double precision, integer, character varying, integer, integer, double precision, integer, double precision, integer, integer)
  OWNER TO postgres;






CREATE OR REPLACE FUNCTION public.p_est_prod_descontos(
    integer,
    integer,
    double precision,
    integer,
    character varying,
    integer,
    integer,
    double precision,
    integer,
    double precision,
    integer,
    integer,
    integer,
    character varying)
  RETURNS SETOF rs_produto AS
$BODY$
	DECLARE 
	returnRec rs_produto;
BEGIN

	if not $14 is null and $14 <> '' then
		returnRec = p_est_prod_descontos($1,$2,$14::double precision,$4,$5,1,$7,$8,$9,$10,$11,$12,0);
	else
	 
		 
		returnRec = p_est_prod_descontos($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,0);
	 
	end if;
	 
	 RETURN NEXT returnRec;
END;
-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.p_est_prod_descontos(integer, integer, double precision, integer, character varying, integer, integer, double precision, integer, double precision, integer, integer, integer, character varying)
  OWNER TO postgres;

CREATE OR REPLACE FUNCTION public.p_est_prod_descontos(
	integer,
	integer,
	double precision,
	integer,
	character varying,
	integer,
	integer,
	double precision,
	integer,
	double precision,
	integer,
	integer,
	integer)
  RETURNS SETOF rs_produto AS
$BODY$
	DECLARE 
	returnRec rs_produto;
BEGIN
	 returnRec = p_est_prod_descontos($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,-1);
	 RETURN NEXT returnRec;
END;
-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.p_est_prod_descontos(	integer,
											integer,
											double precision,
											integer,
											character varying,
											integer,
											integer,
											double precision,
											integer,
											double precision,
											integer,
											integer,
											integer)
  OWNER TO postgres;

CREATE OR REPLACE FUNCTION p_est_prod_descontos(
	integer, 
	integer, 
	double precision, 
	integer, 
	character varying,
	integer, 
	integer, 
	double precision, 
	integer, 
	double precision, 
	integer, 
	integer, 
	integer, 
	integer)
RETURNS SETOF public.rs_produto AS
$body$
	DECLARE 
	returnRec rs_produto;
BEGIN
	returnRec = p_est_prod_descontos($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, 0);
	RETURN NEXT returnRec;
END
-- fim bloco principal
$body$
	LANGUAGE 'plpgsql' VOLATILE
	COST 10 
	ROWS 1000;
ALTER FUNCTION public.p_est_prod_descontos(	integer,
											integer,
											double precision,
											integer,
											character varying,
											integer,
											integer,
											double precision,
											integer,
											double precision,
											integer,
											integer,
											integer,
											integer)
  OWNER TO postgres;	